
function AISMN_FollowObject::OnEnter(%this,%obj)
{
	//Set a path to our target.
	%tar = GetParameterTarget(%obj);
	if(%tar)
	{
      %tar_pos = %tar.getPosition(); 
      %pos_x = getWord(%tar_pos,0); 
      %pos_y = getWord(%tar_pos,1);
      SetPathToSpot( %obj, %pos_x, %pos_y );
      GetThisObject(%obj).playThread( 0, "run");
	}
   return;
}

function AISMN_FollowObject::OnExit(%this,%obj)
{
   StopMoving(%obj);
   GetThisObject(%obj).playThread( 0, "root");
   SetSpeedScalar(%obj,1.0);
   return;
}

//EXIT 0: TARGET DOESN'T EXIST
function AISMN_FollowObject::Update(%this,%obj)
{
   //Get the AI of the target.
	%tar = GetParameterTarget(%obj);
   %tar_ai = slgQueryInterface(%tar, $CID_AI); 
   
   if(%tar_ai)
   {
      if(IsFollowingPath(%tar_ai))
      {
         //Inc the frame counter
         SetStateVariable(%obj,0,GetStateVariable(%obj,0)+1);
         
         if(GetStateVariable(%obj,0) > 10)
         {
            SetStateVariable(%obj,0,0);
            %tar_pos = %tar.getPosition(); 
            %pos_x = getWord(%tar_pos,0); 
            %pos_y = getWord(%tar_pos,1);
            SetPathToSpot( %obj, %pos_x, %pos_y );
            GetThisObject(%obj).playThread( 0, "run");
         }
      }
      else if(slgDistanceBetweenSquared(GetThisObject(%obj),%tar) < 8.0 && TimeInNode(%obj) > 0.5)
      {
         ReturnValue(%obj,1);
         return;
      }
   }
   //No target was found
   else
   {
      ReturnValue(%obj,0);
      return;
   }
   ReturnValue(%obj,-1);
   return;
}
